package com.example.tp6_01;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;

import java.util.Map;

public class MainActivity extends AppCompatActivity {
    private static final String TAG = "MainActivity";
    final String[] permissions = {
            Manifest.permission.SEND_SMS,
            Manifest.permission.CAMERA,
            Manifest.permission.ACCESS_COARSE_LOCATION,
            Manifest.permission.READ_CONTACTS
    };
        ActivityResultLauncher<String[]> launcher = (ActivityResultLauncher<String[]>) registerForActivityResult(
        new ActivityResultContracts.RequestMultiplePermissions(),
        new ActivityResultCallback<Map<String, Boolean>>() {
            @Override
            public void onActivityResult(Map<String, Boolean> result) {
                boolean allGranted = true;
                for( Map.Entry<String,Boolean> entry : result.entrySet()){
                    Log.i( TAG,"Key = " + entry.getKey() +", Value = " + entry.getValue());
                    if(entry.getValue() == false){
                        allGranted = false;
                    }
                }
                if( ! allGranted ){
                    Toast.makeText( MainActivity.this, "Some permission is missing", Toast.LENGTH_SHORT ).show();
                    finish();
                }
            }
        });

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        if(!hasPermissions()){
            launcher.launch(permissions);
        }
    }

    private boolean hasPermissions() {
            for (String permission : permissions) {
                if (ActivityCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED) {
                    Log.i(TAG, "Permission is denied: " + permission);
                    return false;
                }
                Log.i(TAG, "Permission already granted: " + permission);
            }
            return true;
    }
}
